package ru.yandex.travel.externalapi.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.async.DeferredResult;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.WildcardType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import ru.yandex.travel.externalapi.security.OAuthAuthorizationInterceptor;

import static springfox.documentation.schema.AlternateTypeRules.newRule;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration {
    @Autowired
    private TypeResolver typeResolver;

    private final List<Parameter> globalParams = List.of(
            new ParameterBuilder()
                    .name(OAuthAuthorizationInterceptor.AUTHORIZATION_HEADER_NAME)
                    .description("Authorization header с OAuth токеном для авторизации запроса")
                    .modelRef(new ModelRef("string"))
                    .parameterType("header")
                    .build());

    private Docket createDocket(Set<String> packagePrefixes, String groupName, String apiTitle, String apiDescription) {
        return new Docket(DocumentationType.SWAGGER_2)
                .select()
                .apis(packagePrefixes.stream()
                        .map(RequestHandlerSelectors::basePackage)
                        .reduce(x -> false, Predicates::or)
                )
                .build()
                .genericModelSubstitutes(ResponseEntity.class)
                .alternateTypeRules(
                        newRule(typeResolver.resolve(DeferredResult.class,
                                        typeResolver.resolve(ResponseEntity.class, WildcardType.class)),
                                typeResolver.resolve(WildcardType.class)),
                        newRule(typeResolver.resolve(DeferredResult.class, WildcardType.class),
                                typeResolver.resolve(WildcardType.class)))
                .groupName(groupName)
                .apiInfo(new ApiInfo(
                        apiTitle, apiDescription,
                        null, null, null, null, null,
                        Collections.emptyList()))
                .globalOperationParameters(globalParams);
    }

    @Bean
    public Docket externalApi() {
        Set<String> packagePrefixes = Set.of(
                "ru.yandex.travel.externalapi.endpoint.travelline",
                "ru.yandex.travel.externalapi.endpoint.bnovo",
                "ru.yandex.travel.externalapi.endpoint.google_hotels"
        );
        String groupName = "1. API для Партнеров";
        String apiTitle = "API для Партнеров";
        String apiDescription = "API необходимое для подключения отелей Партнеров";

        return createDocket(packagePrefixes, groupName, apiTitle, apiDescription);
    }

    @Bean
    public Docket affiliateApi() {
        Set<String> packagePrefixes = Set.of("ru.yandex.travel.externalapi.endpoint.affiliate");
        String groupName = "2. Affiliate API";
        String apiTitle = "Affiliate API";
        String apiDescription = "API для Admitad и TravelPayOuts";

        return createDocket(packagePrefixes, groupName, apiTitle, apiDescription);
    }
}
