package ru.yandex.travel.externalapi.configuration;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import ru.yandex.inside.passport.blackbox.Blackbox;
import ru.yandex.travel.externalapi.security.AuthorizationProperties;
import ru.yandex.travel.externalapi.security.OAuthAuthorizationInterceptor;
import ru.yandex.travel.tvm.TvmWrapper;

@Slf4j
@Configuration
@EnableConfigurationProperties({
        AuthorizationProperties.class,
        ExternalApiProperties.class
})
public class WebConfiguration implements WebMvcConfigurer {
    @Autowired
    private AuthorizationProperties authorizationProperties;

    @Autowired(required = false)
    private TvmWrapper tvm;

    @Bean
    public ErrorAttributes customErrorAttributes() {
        return new CustomErrorAttributes();
    }

    @Bean
    public Blackbox getBlackbox() {
        return new Blackbox(authorizationProperties.getBlackboxUrl());
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        if (authorizationProperties.getOauthEnabled()) {
            Preconditions.checkState(tvm != null, "TVM should be enabled, when authentication is enabled");
            OAuthAuthorizationInterceptor authorizationInterceptor = new OAuthAuthorizationInterceptor(
                    tvm, getBlackbox(), authorizationProperties);
            log.info("Creating OAuth interceptor for API calls");
            registry.addInterceptor(authorizationInterceptor)
                    .addPathPatterns("/travelline/**")
                    .addPathPatterns("/bnovo/**")
                    .addPathPatterns("/admitad/**")
                    .addPathPatterns("/travelpayouts/**")
                    .excludePathPatterns("/google_hotels/**");
        }
    }
}
