package ru.yandex.travel.externalapi.endpoint.affiliate;

import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import ru.yandex.travel.externalapi.endpoint.affiliate.model.AffiliateOrdersRsp;
import ru.yandex.travel.externalapi.service.AffiliateService;

@RequiredArgsConstructor
public abstract class AffiliateController {
    private final AffiliateService affiliateService;
    private final EAffiliateId affiliateId;

    @RequestMapping(value = "/get_orders_data", method = RequestMethod.GET, produces = "application/json")
    public AffiliateOrdersRsp getOrdersData(
            @RequestParam(value = "dateFrom") String dateFrom,
            @RequestParam(value = "dateTo") String dateTo,
            @RequestParam(value = "offset", required = false, defaultValue = "0") int offset,
            @RequestParam(value = "limit", required = false, defaultValue = "5000") int limit
    ) {
        return affiliateService.getOrdersData(affiliateId, dateFrom, dateTo, offset, limit);
    }

    @RequestMapping(value = "/get_updated_orders_data", method = RequestMethod.GET, produces = "application/json")
    public AffiliateOrdersRsp getUpdatedOrdersData(
            @RequestParam(value = "dateFrom") String dateFrom,
            @RequestParam(value = "dateTo") String dateTo,
            @RequestParam(value = "offset", required = false, defaultValue = "0") int offset,
            @RequestParam(value = "limit", required = false, defaultValue = "5000") int limit
    ) {
        return affiliateService.getUpdatedOrdersData(affiliateId, dateFrom, dateTo, offset, limit);
    }
}
