package ru.yandex.travel.externalapi.endpoint.affiliate.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@Getter
@RequiredArgsConstructor
public enum EAffiliateOrderType implements ValueBasedEnum<String> {
    HOTELS("hotels"),
    TRAIN("train"),
    AVIA("avia");

    private final String value;

    public static final EnumIndex<String, EAffiliateOrderType> index = EnumIndex.create(EAffiliateOrderType.class);

    public static EAffiliateOrderType fromString(String value) {
        return index.getByValue(value);
    }
}
