package ru.yandex.travel.externalapi.endpoint.bnovo;

import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.externalapi.endpoint.ControllerHelpers;
import ru.yandex.travel.externalapi.endpoint.bnovo.model.HotelStatusRsp;
import ru.yandex.travel.externalapi.endpoint.model.AcceptAgreementReq;
import ru.yandex.travel.externalapi.endpoint.model.AcceptAgreementRsp;
import ru.yandex.travel.externalapi.endpoint.model.CheckAgreementRsp;
import ru.yandex.travel.externalapi.endpoint.model.HotelDetailsChangedReq;
import ru.yandex.travel.externalapi.endpoint.model.HotelInventoryChangesReq;
import ru.yandex.travel.externalapi.service.BnovoHotelsService;
import ru.yandex.travel.hotels.proto.EOfferInvalidationSource;
import ru.yandex.travel.hotels.proto.EPartnerId;

@RestController
@RequiredArgsConstructor
@RequestMapping(value = "/bnovo")
public class BnovoController {

    private final BnovoHotelsService bnovoHotelsService;

    @RequestMapping(value = "/hotel_details_changed", method = RequestMethod.POST, consumes = "application/json")
    public DeferredResult<ResponseEntity<Void>> postHotelDetailsChanged(@RequestBody HotelDetailsChangedReq request) {
        return ControllerHelpers.replyWithFuture(bnovoHotelsService.notifyHotelDetailsChanged(request)
                .thenApply(rsp -> ResponseEntity.status(HttpStatus.OK).build()));
    }

    @RequestMapping(value = "/hotel_status", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<ResponseEntity<HotelStatusRsp>> getHotelStatus(@RequestParam(name = "hotel_code") String hotelCode) {
        return ControllerHelpers.replyWithFuture(bnovoHotelsService.getHotelStatus(hotelCode)
                .thenApply(rsp -> {
                    if (rsp == null) {
                        return ResponseEntity.status(HttpStatus.NOT_FOUND).build();
                    } else {
                        return ResponseEntity.status(HttpStatus.OK).body(rsp);
                    }
                }));
    }

    @RequestMapping(value = "/check_agreement", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<CheckAgreementRsp> checkAgreement(@RequestParam(name = "inn") String inn) {
        return ControllerHelpers.replyWithFuture(bnovoHotelsService.checkAgreement(inn));
    }

    @RequestMapping(value = "/accept_agreement", method = RequestMethod.POST, consumes = "application/json", produces = "application/json")
    public DeferredResult<AcceptAgreementRsp> acceptAgreement(@RequestBody AcceptAgreementReq request) {
        return ControllerHelpers.replyWithFuture(bnovoHotelsService.acceptAgreement(request, EPartnerId.PI_BNOVO));
    }

    @RequestMapping(value = "/hotel_inventory_changes", method = RequestMethod.POST, consumes = "application/json", produces = "application/json")
    public DeferredResult<Object> postHotelInventoryChanges(@RequestBody HotelInventoryChangesReq request) {
        return ControllerHelpers.replyWithFuture(bnovoHotelsService.hotelInventoryChanges(request, EPartnerId.PI_BNOVO, EOfferInvalidationSource.OIS_PARTNER_HOOK_BNOVO));
    }
}
