package ru.yandex.travel.externalapi.endpoint.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum UnpublishedReason {

    NONE("none"),
    NO_AGREEMENT("no_agreement"),
    UPDATING("updating"),
    SUSPENDED("suspended"),
    DELAYED("delayed");

    private final String value;

    UnpublishedReason(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static UnpublishedReason fromString(String value) {
        for (UnpublishedReason candidate : UnpublishedReason.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown unpublished reason %s", value)
        );
    }

}
