package ru.yandex.travel.externalapi.endpoint.google_hotels.model;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotEmpty;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

import ru.yandex.travel.externalapi.endpoint.google_hotels.model.query.Context;

@Data
@JacksonXmlRootElement(localName = "Query")
public class QueryReq implements Serializable {
    @JacksonXmlProperty(localName = "latencySensitive", isAttribute = true)
    Boolean latencySensitive = false;

    @JacksonXmlProperty(localName = "Checkin")
    String checkIn;
    @Max(value = 30, message = "Nights should not be greater than 30")
    @JacksonXmlProperty(localName = "Nights")
    Integer nights;

    @JacksonXmlProperty(localName = "FirstDate")
    String firstDate;
    @JacksonXmlProperty(localName = "LastDate")
    String lastDate;

    @JacksonXmlProperty(localName = "AffectedNights")
    Integer affectedNights;

    @NotEmpty
    @JacksonXmlElementWrapper(localName = "PropertyList")
    @JacksonXmlProperty(localName = "Property")
    List<String> properties;

    @JacksonXmlProperty(localName = "Context")
    Context context;
}
