package ru.yandex.travel.externalapi.endpoint.google_hotels.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.externalapi.endpoint.google_hotels.model.query.PropertyDataSet;
import ru.yandex.travel.externalapi.endpoint.google_hotels.model.query.Result;

@Value
@Builder
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JacksonXmlRootElement(localName = "Transaction")
public class QueryRsp {
    @JacksonXmlProperty(localName = "timestamp", isAttribute = true)
    String timestamp;
    @JacksonXmlProperty(localName = "id", isAttribute = true)
    String id;
    @JacksonXmlElementWrapper(useWrapping = false)
    @JacksonXmlProperty(localName = "PropertyDataSet")
    List<PropertyDataSet> properties;
    @JacksonXmlElementWrapper(useWrapping = false)
    @JacksonXmlProperty(localName = "Result")
    List<Result> results;
}
