package ru.yandex.travel.externalapi.endpoint.google_hotels.model.hint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@EqualsAndHashCode(callSuper = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ExactItinerariesHintItem extends HintItem {
    @JacksonXmlProperty(localName = "Stay")
    HintStay stay;

    @Data
    @Builder
    public static class HintStay {
        @JacksonXmlProperty(localName = "CheckInDate")
        String checkInDate;
        @JacksonXmlProperty(localName = "LengthOfStay")
        Integer lengthOfStay;
    }
}
