package ru.yandex.travel.externalapi.endpoint.google_hotels.model.hint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@EqualsAndHashCode(callSuper = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class RangedStaysHintItem extends HintItem {
    @JacksonXmlProperty(localName = "StaysIncludingRange")
    StaysIncludingRange staysIncludingRange;

    @Data
    @Builder
    public static class StaysIncludingRange {
        @JacksonXmlProperty(localName = "FirstDate")
        String firstDate;
        @JacksonXmlProperty(localName = "LastDate")
        String lastDate;
    }
}
