package ru.yandex.travel.externalapi.endpoint.google_hotels.model.query;

import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

@Data
public class ReqOccupancyDetails {
    @JacksonXmlProperty(localName = "NumAdults")
    Integer numAdults;
    @JacksonXmlElementWrapper(localName = "Children")
    @JacksonXmlProperty(localName = "Child")
    List<Integer> children;

    public void setChildren(List<Child> children) {
        this.children = children.stream().map(Child::getAge).collect(Collectors.toList());
    }

    @Data
    private static class Child {
        @JacksonXmlProperty(isAttribute = true)
        Integer age;
    }
}
