package ru.yandex.travel.externalapi.endpoint.google_hotels.model.query;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class RoomBundle {
    @JacksonXmlProperty(localName = "RoomID")
    String roomID;
    @JacksonXmlProperty(localName = "PackageID")
    String packageID;
    @JacksonXmlProperty(localName = "Baserate")
    Rate baseRate;
    @JacksonXmlProperty(localName = "Tax")
    Rate tax;
    @JacksonXmlProperty(localName = "OtherFees")
    Rate otherFees;
    @JacksonXmlProperty(localName = "Refundable")
    Refundable refundable;
    @JacksonXmlProperty(localName = "Occupancy")
    Integer occupancy;
    @JacksonXmlProperty(localName = "OccupancyDetails")
    RspOccupancyDetails occupancyDetails;
    @JacksonXmlProperty(localName = "BreakfastIncluded")
    Boolean breakfastIncluded;
    @JacksonXmlProperty(localName = "RatePlanID")
    String ratePlanID;
}
