package ru.yandex.travel.externalapi.endpoint.google_hotels.model.query;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class RoomData {
    @JacksonXmlProperty(localName = "RoomID")
    String roomID;
    @JacksonXmlElementWrapper(localName = "Name")
    @JacksonXmlProperty(localName = "Text")
    List<Text> names;
    @JacksonXmlElementWrapper(useWrapping = false)
    @JacksonXmlProperty(localName = "PhotoURL")
    List<PhotoUrl> photoUrls;
}
