package ru.yandex.travel.externalapi.endpoint.google_hotels.model.query;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class RspOccupancyDetails {
    @JacksonXmlProperty(localName = "NumAdults")
    Integer numAdults;
    @JacksonXmlElementWrapper(localName = "Children")
    @JacksonXmlProperty(localName = "Child")
    List<Child> children;

    @Value
    @Builder
    public static class Child {
        @JacksonXmlProperty(isAttribute = true)
        Integer age;
    }

}
