package ru.yandex.travel.externalapi.endpoint.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = AcceptAgreementReq.AcceptAgreementReqBuilder.class)
public class AcceptAgreementReq {

    private final String hotelCode;

    private final String inn;

    private final ContactInfo contactInfo;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AcceptAgreementReqBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = ContactInfo.ContactInfoBuilder.class)
    public static class ContactInfo {

        private final String name;

        private final String position;

        private final String phone;

        private final String email;

        @JsonPOJOBuilder(withPrefix = "")
        public static class ContactInfoBuilder {
        }
    }
}
