package ru.yandex.travel.externalapi.endpoint.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder = AcceptAgreementRsp.AcceptAgreementRspBuilder.class)
public class AcceptAgreementRsp {

    private final AcceptAgreementStatus status;

    private final String message;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AcceptAgreementRspBuilder {
    }
}
