package ru.yandex.travel.externalapi.endpoint.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AcceptAgreementStatus {

    SUCCESS("success"),
    FAILURE("failure");

    private final String value;

    AcceptAgreementStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static AcceptAgreementStatus fromString(String value) {
        for (AcceptAgreementStatus candidate : AcceptAgreementStatus.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown accept agreement status %s", value)
        );
    }
}
