package ru.yandex.travel.externalapi.endpoint.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AgreementStatusType {

    FOUND("found"),
    NOT_FOUND("not_found"),
    BLOCKED("blocked");

    private final String value;

    AgreementStatusType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static AgreementStatusType fromString(String value) {
        for (AgreementStatusType candidate : AgreementStatusType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown agreement status %s", value)
        );
    }
}
