package ru.yandex.travel.externalapi.endpoint.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum HotelStatusEnum {

    PUBLISHING("publishing"),
    PUBLISHED("published"),
    UNPUBLISHED("unpublished");

    private final String value;

    HotelStatusEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static HotelStatusEnum fromString(String value) {
        for (HotelStatusEnum candidate : HotelStatusEnum.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown hotel status %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
