package ru.yandex.travel.externalapi.endpoint.travelline;

import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.externalapi.endpoint.ControllerHelpers;
import ru.yandex.travel.externalapi.endpoint.model.AcceptAgreementReq;
import ru.yandex.travel.externalapi.endpoint.model.AcceptAgreementRsp;
import ru.yandex.travel.externalapi.endpoint.model.CheckAgreementRsp;
import ru.yandex.travel.externalapi.endpoint.model.HotelDetailsChangedReq;
import ru.yandex.travel.externalapi.endpoint.travelline.model.HotelStatusRsp;
import ru.yandex.travel.externalapi.service.TravellineHotelsService;
import ru.yandex.travel.hotels.proto.EPartnerId;

@RestController
@RequiredArgsConstructor
@RequestMapping(value = "/travelline")
public class TravellineController {

    private final TravellineHotelsService travellineHotelsService;

    @RequestMapping(value = "/hotel_details_changed", method = RequestMethod.POST, consumes = "application/json")
    public DeferredResult<ResponseEntity<Void>> postHotelDetailsChanged(@RequestBody HotelDetailsChangedReq request) {
        return ControllerHelpers.replyWithFuture(travellineHotelsService.notifyHotelDetailsChanged(request)
                .thenApply(rsp -> ResponseEntity.status(HttpStatus.OK).build()));
    }

    @RequestMapping(value = "/hotel_status", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<HotelStatusRsp> getHotelStatus(@RequestParam(name = "hotel.code") String hotelCode) {
        return ControllerHelpers.replyWithFuture(travellineHotelsService.getHotelStatus(hotelCode));
    }

    @RequestMapping(value = "/check_agreement", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<CheckAgreementRsp> checkAgreement(@RequestParam(name = "inn") String inn) {
        return ControllerHelpers.replyWithFuture(travellineHotelsService.checkAgreement(inn));
    }

    @RequestMapping(value = "/accept_agreement", method = RequestMethod.POST, consumes = "application/json",
            produces = "application/json")
    public DeferredResult<AcceptAgreementRsp> acceptAgreement(@RequestBody AcceptAgreementReq request) {
        return ControllerHelpers.replyWithFuture(travellineHotelsService.acceptAgreement(request, EPartnerId.PI_BNOVO));
    }

}
