package ru.yandex.travel.externalapi.endpoint.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DisconnectionReason {

    NONE("none"),
    NO_AGREEMENT("no_agreement"),
    SUSPENDED("suspended"),
    UPDATING("updating"),
    DELAYED("delayed");

    private final String value;

    DisconnectionReason(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static DisconnectionReason fromString(String value) {
        for (DisconnectionReason candidate : DisconnectionReason.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown disconnection reason %s", value)
        );
    }

}
