package ru.yandex.travel.externalapi.endpoint.travelline.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.externalapi.endpoint.model.HotelStatusEnum;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@NoArgsConstructor
public class HotelStatus {

    private HotelRef hotelRef;

    private HotelStatusEnum status;

    private DisconnectionReason disconnectionReason;

    private String agreementId;

    private String agreementFrom;

    private String hotelUrl;

    @Getter
    @RequiredArgsConstructor
    public static class HotelRef {

        private final String code;

    }
}
