package ru.yandex.travel.externalapi.endpoint.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ResponseErrorCode {
    HOTEL_NOT_FOUND("392", "Hotel is not found"),
    UNKNOWN(null, null);

    private final String code;

    private final String message;

    ResponseErrorCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @JsonCreator
    public static ResponseErrorCode fromString(String value) {
        for (ResponseErrorCode candidate : ResponseErrorCode.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        return UNKNOWN;
    }

    @JsonValue
    public String getValue() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
