package ru.yandex.travel.externalapi.security;

import java.util.HashMap;
import java.util.Map;

import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@Getter
@Setter
@ConfigurationProperties(value = "authorization", ignoreUnknownFields = false)
public class AuthorizationProperties {

    @NotNull
    private Boolean oauthEnabled;

    @NotNull
    private String blackboxUrl;

    @NotNull
    private String tvmBlackboxAlias;

    @NotNull
    private String partnerScope;

    private Map<String, PartnerData> partnerData = new HashMap<>();

    @Data
    public static class PartnerData {

        @NotNull
        private String urlPrefix;

        @NotNull
        private String allowedClientId;
    }
}
