package ru.yandex.travel.externalapi.service.providers;

import io.grpc.Channel;
import io.grpc.stub.AbstractFutureStub;

import ru.yandex.travel.orders.client.HAGrpcChannelFactory;

public abstract class AbstractInterfaceProvider {
    private final HAGrpcChannelFactory channelFactory;

    public AbstractInterfaceProvider(HAGrpcChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public Channel getChannel() {
        return channelFactory.getFastestChannel();
    }

    public abstract AbstractFutureStub provideInterface();
}
