RECURSE(
    src/test
)

JAVA_PROGRAM(external-api)

JDK_VERSION(11)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

EXCLUDE(
    contrib/java/javax/servlet/servlet-api/2.3
)

PEERDIR(
    travel/library/java/spring-boot-skeleton
    travel/library/java/ha-grpc-client
    travel/library/java/yt-lucene-index
    iceberg/inside-passport

    travel/proto/affiliate
    travel/hotels/lib/java/busbroker
    travel/hotels/lib/java/geosearch
    travel/hotels/hotels_administrator/proto
    travel/hotels/proto/offercache_grpc
    travel/hotels/proto/offer_invalidation

    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml
    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/org/springframework/boot/spring-boot-starter-validation
    contrib/java/io/springfox/springfox-swagger2
    contrib/java/io/springfox/springfox-swagger-ui
    contrib/java/javax/xml/bind/jaxb-api
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/external-api.py
    CUSTOM_PROPERTY appName external-api
    CUSTOM_PROPERTY mainClass ru.yandex.travel.externalapi.ExternalApiApplication
)

LINT(base)
END()

