import yargs from 'yargs/yargs';

const argv = yargs(process.argv.slice(2))
    .options({
        config: {
            alias: 'c',
            type: 'string',
            describe: 'Path to bundlemeter config',
        },
        test: {
            alias: 't',
            type: 'boolean',
            describe: 'Will show files',
        },
    })
    .parseSync();

const configPath = String(argv.config);
const onlyShowFiles = Boolean(argv.test);

export {configPath, onlyShowFiles};
