import {ARunner} from '../Runner/baseRunner';
import {AReporter} from '../Reporter/baseReporter';

export class Bundlemeter {
    private runner: ARunner;
    private reporter: AReporter;

    constructor(runner: ARunner, reporter: AReporter) {
        this.runner = runner;
        this.reporter = reporter;
    }

    async run(): Promise<void> {
        const result = await this.runner.run();

        await this.reporter.report(result);
    }
}
