import {ARunner} from '../Runner/baseRunner';
import {AReporter} from '../Reporter/baseReporter';
import {Bundlemeter} from './bundlemeter';

export abstract class ABundlemeterBuilder {
    abstract setRunner(runner: ARunner): void;
    abstract setReporter(reporter: AReporter): void;
}

export class BundlemeterBuilder implements ABundlemeterBuilder {
    private runner!: ARunner;
    private reporter!: AReporter;

    setRunner(runner: ARunner): void {
        this.runner = runner;
    }

    setReporter(reporter: AReporter): void {
        this.reporter = reporter;
    }

    build(): Bundlemeter {
        return new Bundlemeter(this.runner, this.reporter);
    }
}
