import {ABundlemeterBuilder} from './bundlemeterBuilder';
import {ConsoleCoverageReporter} from '../Reporter/consoleCoverageReporter';
import {ChromeRunner} from '../Runner/chromeRunner';
import {ClickhouseReporter} from '../Reporter/clickhouseReporter';
import {ShowFilesRunner} from '../Runner/showFilesRunner';
import {ConsoleShowFilesReporter} from '../Reporter/consoleShowFilesReporter';
import {IRunnerConfig} from '../Runner/IRunner';
import {IChromeReporterConfig} from '../Reporter/IReporter';

export class BundlemeterDirector {
    private builder: ABundlemeterBuilder;
    private runnerConfig: IRunnerConfig;
    private reporterConfig?: IChromeReporterConfig;

    constructor(
        builder: ABundlemeterBuilder,
        runnerConfig: IRunnerConfig,
        reporterConfig?: IChromeReporterConfig,
    ) {
        this.builder = builder;
        this.runnerConfig = runnerConfig;
        this.reporterConfig = reporterConfig;
    }

    buildShowFilseRunner(): void {
        this.builder.setRunner(new ShowFilesRunner(this.runnerConfig));
        this.builder.setReporter(new ConsoleShowFilesReporter());
    }

    buildChromeClickhouseRunner(): void {
        this.builder.setRunner(new ChromeRunner(this.runnerConfig));

        // @ts-ignore
        this.builder.setReporter(new ClickhouseReporter(this.reporterConfig));
    }

    buildChromeConsoleRunner(): void {
        this.builder.setRunner(new ChromeRunner(this.runnerConfig));
        this.builder.setReporter(new ConsoleCoverageReporter());
    }
}
