import ClickHouseApiClient, {
    IClickHouseConnectionConfig,
    TClickHouseColumns,
} from './ClickHouseApiClient/ClickHouseApiClient';

export interface IClickhouseBundlemeter {
    time: string;
    service: string;
    page: string;
    version: string;
    src: string;
    type: string;
    size: number;
}

const clickhouseColumns: TClickHouseColumns<IClickhouseBundlemeter> = {
    time: 'DateTime',
    service: 'String',
    page: 'String',
    version: 'String',
    src: 'String',
    type: 'String',
    size: 'Int64',
};

export class ClickhouseProvider {
    private client: ClickHouseApiClient<IClickhouseBundlemeter>;

    constructor(options: IClickHouseConnectionConfig) {
        this.client = new ClickHouseApiClient({
            ...options,
            columns: clickhouseColumns,
        });
    }

    createIfNotExist(): Promise<boolean> {
        return this.client
            .createTableIfNotExist('time', 'toYYYYMM(time)')
            .then(Boolean);
    }

    insertValues(values: IClickhouseBundlemeter[]): Promise<boolean> {
        return this.client.insertValues(values).then(Boolean);
    }
}
