import {IChromeReporterConfig} from '../Reporter/IReporter';
import {IRunnerConfig} from '../Runner/IRunner';

export interface IConfig {
    clickhouse?: IChromeReporterConfig;
    runner: IRunnerConfig;
}

export interface IUserConfig {
    clickhouse?: IClickhouseConfig;
    include: TSource;
    exclude?: TSource;
    timeout?: number;
    onlyShowFiles?: boolean;
    args?: string[];
}

export interface IClickhouseConfig {
    host: string;
    port: string;
    dbName: string;
    tableName: string;
    version: string;
    serviceName: string;
    username: string;
    password: string;
}

export type TSource = string | string[];
