import * as puppeteer from 'puppeteer';
import {Page, HTTPResponse, ResourceType} from 'puppeteer';

import {TAcceptedResorces} from './ICustomCoverage';
import {IResource} from '../Test/ITest';

export class CustomCoverage {
    static customCoverageToResource(
        uri: string,
        buffer: Buffer,
        type: puppeteer.ResourceType,
    ): IResource {
        return {
            resourceUri: uri,
            resourceSize: buffer.length,
            resourceType: type,
        };
    }

    private page: Page;
    private resources: Promise<IResource>[] = [];

    constructor(page: Page) {
        this.page = page;
    }

    startResourcesCoverage = async (
        acceptedResources: TAcceptedResorces,
    ): Promise<void> => {
        this.page.on('response', this.onResponce.bind(null, acceptedResources));
    };

    stopResourcesCoverage = (): Promise<IResource[]> =>
        Promise.all(this.resources);

    private onResponce = async (
        acceptedResources: TAcceptedResorces,
        res: HTTPResponse,
    ): Promise<void> => {
        // При редиректах сразу выходим, иначе упадем на чтении body
        const status = res.status();

        if (status >= 300 && status < 400) {
            return;
        }

        const type = this.getResourceType(res);

        if (acceptedResources[type]) {
            this.resources.push(
                res
                    .buffer()
                    .then(buffer =>
                        CustomCoverage.customCoverageToResource(
                            res.url(),
                            buffer,
                            type,
                        ),
                    )
                    .catch(e => {
                        console.log(`failed to load ${res.url()}`, e);

                        return CustomCoverage.customCoverageToResource(
                            res.url(),
                            Buffer.alloc(0),
                            type,
                        );
                    }),
            );
        }
    };

    private getResourceType = (res: HTTPResponse): ResourceType =>
        res.request().resourceType();
}
