import puppeteer, {Page, Browser, BrowserContext} from 'puppeteer';

export class PuppeteerHelper {
    private browser: Browser | null = null;
    private context: BrowserContext | null = null;
    private page: Page | null = null;

    private puppeteerOptions: Parameters<typeof puppeteer.launch>[0];

    constructor(puppeteerOptions: Parameters<typeof puppeteer.launch>[0]) {
        this.puppeteerOptions = puppeteerOptions;
    }

    async init(): Promise<void> {
        this.browser = await puppeteer.launch(this.puppeteerOptions);
        this.context = await this.browser.createIncognitoBrowserContext();
        this.page = await this.context.newPage();
    }

    async deinit(): Promise<void> {
        if (this.browser) {
            await this.browser.close();
            this.browser = null;

            return;
        }

        throw new Error('PuppeteerHelper is not inited');
    }

    getPage(): Page {
        if (this.page) {
            return this.page;
        }

        throw new Error('PuppeteerHelper is not inited');
    }
}
