import moment from 'moment';

import {CLICKHOUSE_DATE_FORMAT} from '../Clickhouse/ClickHouseApiClient/constants';

import {AReporter, Reporter} from './baseReporter';
import {ClickhouseProvider} from '../Clickhouse/clickhouseProvider';
import {IChromeReporterConfig} from './IReporter';
import {ICoveredPage} from '../Test/ITest';

export class ClickhouseReporter extends Reporter implements AReporter {
    private readonly provider: ClickhouseProvider;
    private readonly config: IChromeReporterConfig;

    constructor(config: IChromeReporterConfig) {
        super();

        this.config = config;
        this.provider = new ClickhouseProvider({
            dbName: config.dbName,
            tableName: config.tableName,
            host: config.host,
            port: config.port,
            username: config.username,
            password: config.password,
        });
    }

    async report(data: ICoveredPage[]): Promise<void> {
        await this.provider.createIfNotExist();

        const {version, serviceName} = this.config;
        const time = moment().format(CLICKHOUSE_DATE_FORMAT);

        await this.provider.insertValues(
            data.flatMap(page => {
                return page.resources.map(resource => ({
                    time,
                    service: serviceName,
                    page: page.pageName,
                    version,
                    src: resource.resourceUri,
                    type: resource.resourceType,
                    size: resource.resourceSize,
                }));
            }),
        );
    }
}
