import {IConfig, IUserConfig} from './Config/IConfig';
import {BundlemeterBuilder} from './Bundlemeter/bundlemeterBuilder';
import {BundlemeterDirector} from './Bundlemeter/bundlemeterDirector';
import {getConfig} from './Config/config';
import {Bundlemeter} from './Bundlemeter/bundlemeter';

export function createBundlemeter(config: IConfig): Bundlemeter {
    const builder = new BundlemeterBuilder();
    const director = new BundlemeterDirector(
        builder,
        config.runner,
        config.clickhouse,
    );

    if (config.runner.onlyShowFiles) {
        director.buildShowFilseRunner();
    } else if (config.clickhouse) {
        director.buildChromeClickhouseRunner();
    } else {
        director.buildChromeConsoleRunner();
    }

    return builder.build();
}

export function createBundlemeterManually(
    userConfig: IUserConfig,
): Bundlemeter {
    const config = getConfig(userConfig);

    return createBundlemeter(config);
}
