#!/usr/bin/env bash

# shellcheck source=/dev/null
source "$ARCADIA_PATH/$TRAVEL_CI_PATH/registry/init.sh"

_tsPrepare

cd "$ARCADIA_PATH/$TRAVEL_CI_PATH" || exit 1
bundlemeterVersion=$(node -pe "require('./package').devDependencies['@yandex-data-ui/bundlemeter'] || 'latest'")
npm i -D --no-package-lock @yandex-data-ui/bundlemeter@"${bundlemeterVersion/\^/}"

SCRIPT_DIR="$( cd -- "$( dirname -- "${BASH_SOURCE[0]:-$0}"; )" &> /dev/null && pwd 2> /dev/null; )";
result=$(ts-node "$SCRIPT_DIR/bundlemeter.ts")

# shellcheck source=/dev/null
source "$ARCADIA_PATH/$TRAVEL_CI_PATH/registry/exit.sh" "${result}"
