import {createBundlemeterManually} from '@yandex-data-ui/bundlemeter';
import StartrekService from 'src/services/startrek/startrek';

import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';
import {Logger} from 'src/utilities/logger';
import {addBadge} from 'src/helpers/common.helpers';

(async function () {
    const logger = new Logger('BUNDLEMETER');

    try {
        const coverPath = getEnvVariable(
            EEnvironmentVariables.BUNDLEMETER_COVER_PATH,
        );
        const clickhouseHost = getEnvVariable(
            EEnvironmentVariables.BUNDLEMETER_CLICKHOUSE_HOST,
        );
        const clickhousePort = getEnvVariable(
            EEnvironmentVariables.BUNDLEMETER_CLICKHOUSE_PORT,
        );
        const username = getEnvVariable(
            EEnvironmentVariables.BUNDLEMETER_CLICKHOUSE_USERNAME,
        );
        const password = getEnvVariable(
            EEnvironmentVariables.BUNDLEMETER_CLICKHOUSE_PASSWORD,
        );
        const version = getEnvVariable(EEnvironmentVariables.APP_VERSION);

        const bundlemeter = createBundlemeterManually({
            clickhouse: {
                host: clickhouseHost,
                port: clickhousePort,
                username,
                password,
                dbName: 'db_bundlemeter',
                tableName: 'travel',
                serviceName: 'travel',
                version,
            },
            include: coverPath,
            args: ['--no-sandbox'],
        });

        await bundlemeter.run();

        await addBadge({
            id: 'instance',
            module: 'SANDBOX',
            status: 'SUCCESSFUL',
            text: 'Chart in datalens',
            url: 'https://datalens.yandex-team.ru/preview/2wj09ogyt1ssy?environment=production',
        });

        const ticket = getEnvVariable(EEnvironmentVariables.STARTREK_TICKET_ID);
        const startrekToken = getEnvVariable(
            EEnvironmentVariables.STARTREK_TOKEN,
        );

        if (ticket && startrekToken) {
            const STClient = new StartrekService({
                oauth: startrekToken,
            });

            const chartCode =
                '{{iframe frameborder="0" width="100%" height="400px" src="https://charts.yandex-team.ru/preview/editor/2wj09ogyt1ssy?environment=production&_embedded=1"}}';

            await STClient.appendComment({
                ticket,
                text: chartCode,
            });
        }

        logger.success('ok');
    } catch (error) {
        if (error instanceof Error) {
            logger.logError(error);
        }
    }
})();
