import * as path from 'path';

import {Logger} from 'src/utilities/logger';
import {addBadge, exec} from 'src/helpers/common.helpers';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

import patchDeployConfig from './utiltities/patchDeployConfig';

(async function () {
    const logger = new Logger('DEPLOY:CREATE_STAGE');

    try {
        const stageName = getEnvVariable(
            EEnvironmentVariables.DEPLOY_STAGE_NAME,
        );
        const configPath = getEnvVariable(
            EEnvironmentVariables.DEPLOY_CONFIG_PATH,
        );

        const badge = {
            id: 'deploy',
            module: 'YANDEX_DEPLOY',
            status: 'SUCCESSFUL',
            text: 'Stage in Y.Deploy',
            url: `https://deploy.yandex-team.ru/stages/${stageName}`,
        };

        try {
            await exec(`ya dctl get stage ${stageName}`);

            await addBadge(badge);

            logger.success('ok');

            return;
        } catch (e) {
            if (e instanceof Error) {
                logger.log(e.message);
            }
        }

        const standConfigPath = path.join(
            configPath,
            '..',
            `${stageName}.yaml`,
        );

        patchDeployConfig({
            input: configPath,
            output: standConfigPath,
            stageName,
        });

        await exec(
            `ya tool dctl put stage ${standConfigPath} --rewrite-delegation-tokens`,
        );

        await addBadge(badge);

        logger.success('ok');
    } catch (error) {
        if (error instanceof Error) {
            logger.logError(error);
        }
    }
})();
