import fs from 'fs';
import yaml from 'js-yaml';

interface IPatchConfigParams {
    input: string;
    output: string;
    stageName: string;
}

export default function patchDeployConfig({
    input,
    output,
    stageName,
}: IPatchConfigParams): void {
    const data: any = yaml.load(fs.readFileSync(input, 'utf-8'), {
        json: true,
    });

    data.meta.id = stageName;

    fs.writeFileSync(output, yaml.dump(data));
}
