#!/usr/bin/env bash

# https://a.yandex-team.ru/arc_vcs/travel/frontend/portal/docs/teamcity-agents.md/#установка-и-настройка-docker

# shellcheck source=/dev/null
source "$ARCADIA_PATH/ci/tasklet/registry/common/misc/run_command/docker/docker_setup_0.sh"

echo '{
    "iptables": false,
    "ip-forward": false,
    "ipv6": true,
    "dns": [
        "2a02:6b8:0:3400::1023",
        "2a02:6b8:0:3400::5005"
    ],
    "fixed-cidr": "",
    "fixed-cidr-v6": "fd00::/8"
}' >> /etc/docker/daemon.json;

service docker stop && ip link del docker0 && service docker start
ip6tables -t nat -A POSTROUTING -o eth0 -j MASQUERADE
sysctl -w net.ipv6.conf.all.forwarding=1
ip6tables -t nat -A POSTROUTING \! -o docker0 -j MASQUERADE

docker login -u "$DOCKER_REGISTRY_USER" -p "$DOCKER_REGISTRY_TOKEN" registry.yandex.net
