import FarmService from 'src/services/farm/farm';

import {Logger} from 'src/utilities/logger';
import {addBadge} from 'src/helpers/common.helpers';
import {getFarmContext} from 'src/utilities/farm';

(async function (): Promise<void> {
    const logger = new Logger('DeleteInstance');

    try {
        const context = getFarmContext();

        const farm = new FarmService(context);

        await farm.webhook({action: 'closed'});

        addBadge({
            id: 'project',
            module: 'FARM',
            status: 'SUCCESSFUL',
            text: 'Project url',
            url: farm.getProjectUrl(),
        });
        logger.success('ok');
    } catch (error) {
        logger.logError(error as Error);
    }
})();
