import FarmService from 'src/services/farm/farm';
import StartrekService from 'src/services/startrek/startrek';

import {changePullRequestCITable} from 'src/helpers/arcanum.helpers';
import {addBadge, addResource} from 'src/helpers/common.helpers';
import {Logger} from 'src/utilities/logger';
import {
    getCrowdtestBalancerFarmUrl,
    getFarmContext,
    getStorybookFarmUrl,
} from 'src/utilities/farm';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

(async function () {
    const logger = new Logger('GenerateInstance');

    try {
        const context = getFarmContext();

        const farm = new FarmService(context);

        await farm.webhook({action: 'opened'});

        const {url} = await farm.pollInstance();

        await addBadge({
            id: 'instance',
            module: 'FARM',
            status: 'SUCCESSFUL',
            text: 'Instance url',
            url,
        });
        await addResource(url, 'url');

        const {
            pullRequestId,
            crowdtestUrl,
            storybookUrl,
            standKey,
            ciTableKey,
            messagePrefixString,
        } = context;

        if (pullRequestId) {
            await changePullRequestCITable(
                pullRequestId,
                [{key: ciTableKey, value: url}],
                description =>
                    description.replace(/(farm_link|farm_url)/g, url),
            );
        }

        const branch = context.featureBranch;
        const ticket = getEnvVariable(
            EEnvironmentVariables.STARTREK_TICKET_ID,
            '',
        );

        if (ticket) {
            const token = getEnvVariable(EEnvironmentVariables.STARTREK_TOKEN);

            const message = `${messagePrefixString} ((${url} здесь)).`;
            const STClient = new StartrekService({
                oauth: token,
            });

            const messages = await STClient.getTicketCommentsList({ticket});

            if (!messages.includes(message)) {
                try {
                    await STClient.appendComment({ticket, text: message});

                    const fields = {
                        [standKey]: url,
                    };

                    if (storybookUrl) {
                        fields[storybookUrl] = getStorybookFarmUrl(url);
                    }

                    if (crowdtestUrl) {
                        fields[crowdtestUrl] =
                            getCrowdtestBalancerFarmUrl(branch);
                    }

                    await STClient.patchIssue({
                        ticket,
                        fields,
                    });
                } catch (e) {
                    logger.logError(e as Error);
                }
            }
        }

        /* Send successful result to stdout */
        logger.success('ok');
    } catch (error) {
        logger.logError(error as Error);
    }
})();
