import StartrekService from 'src/services/startrek/startrek';

import {Logger} from 'src/utilities/logger';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

(async function () {
    const logger = new Logger('FRIGGA');

    try {
        const startrekParentTicketId = getEnvVariable(
            EEnvironmentVariables.STARTREK_PARENT_TICKET_ID,
        );
        const startrekToken = getEnvVariable(
            EEnvironmentVariables.STARTREK_TOKEN,
        );
        const version = getEnvVariable(EEnvironmentVariables.VERSION);
        const triggeredBy = getEnvVariable(EEnvironmentVariables.TRIGGERED_BY);

        const STClient = new StartrekService({
            oauth: startrekToken,
        });

        const queue = startrekParentTicketId.split('-')[0];

        const summary = `Обновление иконок и иллюстраций ${version}`;
        const description = [
            'Обновление иконок и иллюстраций выполнены в связанном PR.',
            'Можно протестировать самостоятельно, либо отдать команде тестирования.',
        ].join('\n');

        const {key} = await STClient.createTicket({
            queue,
            parent: startrekParentTicketId,
            summary,
            description,
            assignee: triggeredBy,
        });

        /**
         * Возвращаем ключ созданного тикета в stdout
         */
        console.log(key);
    } catch (error) {
        if (error instanceof Error) {
            logger.log(error.message);
        }
    }
})();
