#!/usr/bin/env bash
set -e

arc checkout -b "$BRANCH_NAME"

npm ci
npm run frigga:update

arc add src/icons/*
arc add src/svg/*

arc commit -m "Update icons from figma"

# shellcheck source=/dev/null
source "$ARCADIA_PATH/$TRAVEL_CI_PATH/registry/init.sh"

_tsPrepare

SCRIPT_DIR="$( cd -- "$( dirname -- "${BASH_SOURCE[0]:-$0}"; )" &> /dev/null && pwd 2> /dev/null; )";
STARTREK_TICKET_ID=$(ts-node "$SCRIPT_DIR/frigga-create-ticket.ts")

BADGE_STARTREK="{ \"id\": \"ticketId\", \"module\": \"STARTREK\", \"url\": \"https://st.yandex-team.ru/$STARTREK_TICKET_ID\", \"text\": \"Ticket\", \"status\": \"SUCCESSFUL\" }"
echo "$BADGE_STARTREK"  > "$RESULT_BADGES_PATH/startrek"

PULL_REQUEST=$(arc pr create --push --publish -m "$STARTREK_TICKET_ID: Frigga update by $TRIGGERED_BY #$VERSION")
PULL_REQUEST_URL=$(echo "$PULL_REQUEST" | grep -iw '^https')

BADGE_ARC="{ \"id\": \"pullRequest\", \"module\": \"ARCADIA\", \"url\": \"$PULL_REQUEST_URL\", \"text\": \"Pull Request\", \"status\": \"SUCCESSFUL\" }"
echo "$BADGE_ARC"  > "$RESULT_BADGES_PATH/arcanum"
