#!/usr/bin/env bash

set -e

_log() {
  printf "[%s][%s] %s\n" "$(date +"%T")" "${1}" "${2}"
}

_logNodeVersion() {
  _log "NodeVersion" "$(printf "node: %s, npm: %s\n\n" "$(node -v)" "$(npm -v)")"
}

_logTsNodeVersion() {
  _log "TsNodeVersion" "$(printf "node: %s, npm: %s, ts-node: %s\n\n" "$(node -v)" "$(npm -v)" "$(ts-node -v)")"
}

_tsPrepare() {
  _logTsNodeVersion

  NPM_ROOT=$(npm root -g)
  export NPM_ROOT
  export TS_NODE_PROJECT="$ARCADIA_PATH/$TRAVEL_CI_PATH/tsconfig.json"

  # Installing dependencies of .tsconfig and ts-node
  cd "${ARCADIA_PATH}/$TRAVEL_CI_PATH" || exit

  local typesVersion
  typesVersion=$(node -pe "require('./package').devDependencies['@types/node'] || 'latest'")

  npm i -D --no-package-lock @types/node@"${typesVersion/\^/}" axios tsconfig-paths
}

_log "${0/$ARCADIA_PATH\//}" Init
