import moment from 'moment';

import getPagesMetrics from '../utilities/getPagesMetrics/getPagesMetrics';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

(async (): Promise<void> => {
    try {
        const config = {
            iterationsPerPage: getEnvVariable(
                EEnvironmentVariables.LIGHTHOUSE_ITERATIONS_PER_PAGE,
            ),
            concurrentMeasures: getEnvVariable(
                EEnvironmentVariables.LIGHTHOUSE_CONCURRENT_MEASURES,
            ),
            urls: getEnvVariable(EEnvironmentVariables.LIGHTHOUSE_PAGE_URLS),
        };

        const startMeasuringTime = moment();

        console.log('Lighthouse: запуск замеров');

        const pagesMetrics = await getPagesMetrics(
            config.urls.split(' ').reduce(
                (accPages, pageUrl) => ({
                    ...accPages,
                    [pageUrl]: pageUrl,
                }),
                {},
            ),
            Number(config.concurrentMeasures),
            Number(config.iterationsPerPage),
        );

        console.log(
            `Lighthouse: замеры заняли минут: ${moment().diff(
                startMeasuringTime,
                'minutes',
            )}`,
        );

        console.log(require('util').inspect(pagesMetrics, {depth: 10}));
        console.log('Lighthouse: замеры прошли успешно');
    } catch (err) {
        console.error('Lighthouse: ошибка подсчета метрик', err);
    }
})();
