import {IClickHouseLighthouseMeasure} from '../types';

import ClickHouseApiClient from 'src/services/clickhouse/ClickHouseApiClient';

export default async function hasAlreadyMeasured(
    testingVersion: number,
    lighthouseClickHouseClient: ClickHouseApiClient<IClickHouseLighthouseMeasure>,
): Promise<boolean> {
    return Boolean(
        (
            await lighthouseClickHouseClient.getValues({
                where: `version='${testingVersion}'`,
            })
        ).length,
    );
}
