export interface ILighthouseCalculateOptions {
    url: string;
    iterations: number;
    isDesktop?: boolean;
    needToGenerateReport?: boolean;
    withLogs?: boolean;
}

export interface ILighthouseScoreAndMetrics {
    /**
     * Общая оценка
     */
    score: number;

    /**
     * First contentful paint
     *
     * Время отображения хоть какого-то контента
     */
    fcp: number;

    /**
     * Largest contentful paint
     *
     * Время отображения самого большого элемента на экране
     */
    lcp: number;

    /**
     * Время, отражающее, как быстро отображается контент на странице во время загрузки
     */
    speedIndex: number;

    /**
     * Время до момента, когда пользователь может нормально взаимодействовать со страницей
     */
    tti: number;

    /**
     * Общее время блокировки основного потока долгими задачами (сверх 50мс).
     *
     * Т.е. если задача длится 70мс, то в tbt учтется только 20мс.
     */
    tbt: number;

    /**
     * Общий сдвиг макета
     */
    cls: number;

    /**
     * Максимально возможное время ожидания пользователя при первом взаимодействии со страницей
     */
    maxPotentialFid: number;

    /**
     * Время до первого байта
     */
    ttfb: number;

    /**
     * Общая продолжительность работы в основном потоке
     */
    mainThreadWork: number;

    /**
     * Общее время выполнения скриптов
     */
    jsExecutionTime: number;

    /**
     * Количество элементов в документе.
     */
    domSize: number;
}
