import {fork} from 'child_process';
import path from 'path';

import {
    ILighthouseCalculateOptions,
    ILighthouseScoreAndMetrics,
} from '../../../types';

export default function getPageMetrics(
    options: ILighthouseCalculateOptions,
): Promise<ILighthouseScoreAndMetrics> {
    return new Promise(res => {
        const forked = fork(
            path.resolve(
                './registry/lighthouse/src/utilities/getPagesMetrics/getPageMetrics/getPageMetricsForked.ts',
            ),
            [`-i${options.iterations}`, `-u${options.url}`],
        );

        forked.on('message', res);
    });
}
